%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

%    Differential Gauss' law  -- spherical  symmetry

clear all;
close all;
syms r theta phi
rho = sym('rho','positive');
a = sym('a','positive');
EPS0 = sym('EPS0','positive');
Er1 = rho*r/3/EPS0;
Er2 = rho*a^3/3/EPS0/r^2;
rho1 = divSph(Er1,0,0)*EPS0;
rho2 = divSph(Er2,0,0)*EPS0;
fprintf('\nCharge density is given by the following expressions: ');
fprintf('\nFor r <=a :');
pretty(rho1);
fprintf('\nFor r > a :');
pretty(rho2);     